/**
* \file: AirPlayReceiverSessionHooks.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "AirPlayHeaders.h"

#include "Common.h"
#include "audio/AudioChannel.h"
#include "Server.h"
#include "Session.h"

#include <adit_logging.h>

using namespace adit::carplay;

extern "C" {

// some APIs require us to cast from CFTypeRef to e.g. AirPlayReceiverServerRef const
// which is: const void* -> void* -> void* const
//#define CAST_FROM_CFTYPE(type, obj) reinterpret_cast<type>(const_cast<void*>(obj))
//commented as SA findings and no where its used
CARPLAY_EXPORTED char* AirPlayGetConfigCString(CFStringRef inKey, char* inBuffer,
        size_t inMaxLen, OSStatus* outErr)
{
    if (inMaxLen < 1 || inKey == nullptr || inBuffer == nullptr)
    {
        if (outErr != nullptr)
            *outErr = kParamErr;
        return nullptr;
    }

    auto server = Server::Get(nullptr);
    if (server == nullptr || server->GetConfig() == nullptr)
    {
        if (outErr != nullptr)
            *outErr = kUnknownErr;
        return nullptr;
    }

    char str[1024];
    CFGetCString(inKey, str, 1024);
    auto value = server->GetConfig()->GetItem("core-" + std::string(str), "");

    if (value.length() >= inMaxLen)
    {
        LOG_ERROR((dipo, "configuration value for core-%s is too long (max: %zd)",
                str, inMaxLen - 1));
        if (outErr != nullptr)
            *outErr = kUnknownErr;
        return nullptr;
    }
    else if (!value.empty())
    {
        strncpy(inBuffer, value.c_str(), inMaxLen);
        // overflow checked already
    }
    else
    {
        inBuffer[0] = '\0';
        // no error
    }

    if (outErr != nullptr)
        *outErr = kNoErr;
    return inBuffer;
}

CARPLAY_EXPORTED void AirPlayGetConfigItem(const char* inKey, char* outOut, size_t inMaxLen)
{
    if (inMaxLen < 1 || inKey == nullptr || outOut == nullptr)
        return;

    auto server = Server::Get(nullptr);
    if (server == nullptr || server->GetConfig() == nullptr)
    {
        outOut = nullptr;
        return;
    }

    auto value = server->GetConfig()->GetItem(inKey, "");
    if (value.length() >= inMaxLen)
    {
        LOG_ERROR((dipo, "configuration value for %s is too long (max: %zd)", inKey, inMaxLen - 1));
        outOut = nullptr;
        return;
    }
    else if (!value.empty())
    {
        strncpy(outOut, value.c_str(), inMaxLen);
        // overflow already checked
    }
    else
    {
        outOut[0] = '\0';
        // no error
    }
}

} // extern "C"
